rule Win32_Ransomware_Montserrat : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MONTSERRAT"
        description         = "Yara rule that detects Montserrat ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Montserrat"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            8B FF 55 8B EC 51 8B 4D ?? 53 57 33 DB 8D 51 ?? 66 8B 01 83 C1 ?? 66 3B C3 75 ?? 8B 
            7D ?? 2B CA D1 F9 83 C8 ?? 41 2B C7 89 4D ?? 3B C8 76 ?? 6A ?? 58 EB ?? 56 8D 5F ?? 
            03 D9 6A ?? 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 FF 74 ?? 57 FF 75 ?? 53 56 E8 ?? ?? ?? 
            ?? 83 C4 ?? 85 C0 75 ?? FF 75 ?? 2B DF 8D 04 7E FF 75 ?? 53 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 75 ?? 8B 4D ?? 56 E8 ?? ?? ?? ?? 6A ?? 8B F0 E8 ?? ?? ?? ?? 59 8B C6 5E 5F 
            5B 8B E5 5D C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC 8B FF 55 8B EC 81 EC ?? ?? ?? 
            ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 55 ?? 8B 4D ?? 53 8B 5D ?? 56 57 6A ?? 5E 6A ?? 
            89 95 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 5F EB ?? 0F B7 01 66 3B 85 ?? ?? ?? 
            ?? 74 ?? 66 3B C6 74 ?? 66 3B C7 74 ?? 83 E9 ?? 3B CB 75 ?? 0F B7 31 66 3B F7 75 ?? 
            8D 43 ?? 3B C8 74 ?? 52 33 FF 57 57 53 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 6A ?? 
            8B C6 33 FF 5A 66 3B C2 74 ?? 6A ?? 5A 66 3B C2 74 ?? 6A ?? 5A 66 3B C2 74 ?? 8B C7
        }

        $find_files_p2 = {
            EB ?? 33 C0 40 2B CB 0F B6 C0 D1 F9 41 F7 D8 68 ?? ?? ?? ?? 1B C0 23 C1 89 85 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? 57 57 57 50 
            57 53 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 75 ?? 8B 85 ?? ?? ?? ?? 50 57 57 53 E8 ?? ?? 
            ?? ?? 83 C4 ?? 8B F8 83 FE ?? 74 ?? 56 FF 15 ?? ?? ?? ?? 8B C7 8B 4D ?? 5F 5E 33 CD 
            5B E8 ?? ?? ?? ?? 8B E5 5D C3 8B 8D ?? ?? ?? ?? 6A ?? 8B 41 ?? 2B 01 C1 F8 ?? 89 85 
            ?? ?? ?? ?? 58 66 39 85 ?? ?? ?? ?? 75 ?? 66 39 BD ?? ?? ?? ?? 74 ?? 66 39 85 ?? ?? 
            ?? ?? 75 ?? 66 39 BD ?? ?? ?? ?? 74 ?? 51 FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 
            E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 8B 8D 
            ?? ?? ?? ?? 85 C0 6A ?? 58 75 ?? 8B C1 8B 8D ?? ?? ?? ?? 8B 10 8B 40 ?? 2B C2 C1 F8 
            ?? 3B C8 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 
            83 C4 ?? E9
        }

        $encrypt_files_p1 = {
            8B FF 55 8B EC 83 EC ?? 53 56 57 FF 75 ?? 8D 45 ?? FF 75 ?? FF 75 ?? 50 E8 ?? ?? ?? 
            ?? 83 C4 ?? 8D 7D ?? 8B F0 6A ?? 59 F3 A5 83 CE ?? 39 75 ?? 75 ?? E8 ?? ?? ?? ?? 83 
            20 ?? 8B 45 ?? 89 30 E8 ?? ?? ?? ?? 8B 00 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D ?? 89 
            03 3B C6 75 ?? E8 ?? ?? ?? ?? 83 20 ?? 89 33 E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? EB ?? 
            8B 45 ?? 8D 75 ?? 83 65 ?? ?? 33 C9 41 C7 45 ?? ?? ?? ?? ?? 83 EC ?? 89 08 8B 45 ?? 
            C1 E8 ?? F7 D0 23 C1 6A ?? 59 89 45 ?? 8B FC 8D 45 ?? 50 FF 75 ?? F3 A5 E8 ?? ?? ?? 
            ?? 8B F8 83 C4 ?? 89 7D ?? BA ?? ?? ?? ?? 83 FF ?? 75 ?? 8B 4D ?? 8B C1 23 C2 3B C2 
            75 ?? F6 45 ?? ?? 74 ?? 83 EC ?? 8D 45 ?? 81 E1 ?? ?? ?? ?? 8D 75 ?? 89 4D ?? 6A ?? 
            59 8B FC 50 FF 75 ?? F3 A5 E8 ?? ?? ?? ?? 8B F8 83 C4 ?? 89 7D ?? 83 FF ?? 75 ?? 8B 
            0B 8B C1 83 E1 ?? C1 F8 ?? 6B C9 ?? 8B 04 85 ?? ?? ?? ?? 80 64 08 ?? ?? FF 15 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 59 E9 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? 
            ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 8B 0B 8B C1 83 E1 ?? C1 F8 ?? 6B C9 ?? 57 8B 04 
            85 ?? ?? ?? ?? 80 64 08 ?? ?? FF 15 ?? ?? ?? ?? 85 F6 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? C7 00 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 F8 ?? 75 ?? 8A 45 ?? 0C ?? EB ?? 83 F8 ?? 8A 
        }

        $encrypt_files_p2 = {
            45 ?? 75 ?? 0C ?? 57 FF 33 88 45 ?? E8 ?? ?? ?? ?? 8A 55 ?? 59 59 8B 0B 80 CA ?? 8B 
            C1 88 55 ?? 83 E1 ?? C1 F8 ?? 6B C9 ?? 88 55 ?? 8B 04 85 ?? ?? ?? ?? 88 54 08 ?? 8B 
            0B 8B C1 83 E1 ?? C1 F8 ?? 6B C9 ?? F6 45 ?? ?? 8B 04 85 ?? ?? ?? ?? C6 44 08 ?? ?? 
            74 ?? FF 33 E8 ?? ?? ?? ?? 8B F0 59 85 F6 75 ?? 8D 45 ?? C6 45 ?? ?? 50 FF 75 ?? 8D 
            75 ?? 83 EC ?? 6A ?? 59 8B FC FF 33 F3 A5 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 8B F0 
            FF 33 E8 ?? ?? ?? ?? 59 8B C6 E9 ?? ?? ?? ?? 8B 03 8B C8 83 E0 ?? C1 F9 ?? 6B D0 ?? 
            8A 45 ?? 8B 0C 8D ?? ?? ?? ?? 88 44 11 ?? 8B 0B 8B C1 C1 F8 ?? 83 E1 ?? 6B D1 ?? 8B 
            0C 85 ?? ?? ?? ?? 8B 45 ?? C1 E8 ?? 32 44 11 ?? 24 ?? 30 44 11 ?? F6 45 ?? ?? 75 ?? 
            F6 45 ?? ?? 74 ?? 8B 0B 8B C1 83 E1 ?? C1 F8 ?? 6B C9 ?? 8B 04 85 ?? ?? ?? ?? 80 4C 
            08 ?? ?? 8B 75 ?? B9 ?? ?? ?? ?? 8B C6 23 C1 3B C1 0F 85 ?? ?? ?? ?? F6 45 ?? ?? 74 
            ?? FF 75 ?? FF 15 ?? ?? ?? ?? 83 EC ?? 8D 45 ?? 81 E6 ?? ?? ?? ?? 89 75 ?? 8D 75 ?? 
            6A ?? 59 8B FC 50 FF 75 ?? F3 A5 E8 ?? ?? ?? ?? 8B D0 83 C4 ?? 83 FA ?? 75 ?? FF 15 
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 0B 8B C1 83 E1 ?? C1 F8 ?? 6B C9 ?? 8B 04 85 ?? ?? 
            ?? ?? 80 64 08 ?? ?? FF 33 E8 ?? ?? ?? ?? 59 E9 ?? ?? ?? ?? 8B 0B 8B C1 C1 F8 ?? 83 
            E1 ?? 6B C9 ?? 8B 04 85 ?? ?? ?? ?? 89 54 08 ?? 33 C0 5F 5E 5B 8B E5 5D C3 
        }

        $shutdown_services_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 65 ?? 8B F9 8B 75 ?? 8B 1D 
            ?? ?? ?? ?? FF D3 83 7E ?? ?? 89 45 ?? 72 ?? 8B 36 6A ?? 56 FF 37 FF 15 ?? ?? ?? ?? 
            8B F0 89 75 ?? 85 F6 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 8D 45 ?? 50 6A ?? 56 FF 15 
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 83 F8 ?? 75 ?? 56 FF 15 ?? ?? ?? ?? 8B 
            4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 ?? 
            ?? 83 F8 ?? 75 ?? 66 90 FF 77 ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 8D 45 ?? 50 6A 
            ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? FF D3 2B 45 ?? 3B 
            47 ?? 0F 87 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8B CF E8 
            ?? ?? ?? ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 8B 75 ?? 50 6A ?? 56 FF 15 ?? ?? ?? ?? 85 
            C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 84
        }

        $shutdown_services_p2 = {
            FF 77 ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 8D 45 ?? 50 6A ?? 56 FF 15 ?? ?? ?? ?? 
            85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? FF D3 2B 45 ?? 3B 47 ?? 0F 87 
            ?? ?? ?? ?? 83 7D ?? ?? 75 ?? E9 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 
            E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 
            ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($shutdown_services_p*)
        )
}